package examples.integration.out_loan_ra;

import java.io.*;
import java.util.*;

import javax.resource.*;
import javax.resource.spi.*;
import javax.resource.spi.security.PasswordCredential;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.SecurityException;
import javax.resource.NotSupportedException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class ManagedConnectionImpl implements ManagedConnection {

     private ConnectionEventListener connEventListener;
     private ManagedConnectionFactory manConnFactory;
     private boolean isDestroyed;
     private PrintWriter manConnLogWriter;

     ManagedConnectionImpl (ManagedConnectionFactory manConnFactory) {

          System.out.println("ManagedConnectionImpl(ManagedConnectionFactory) called");

          this.manConnFactory = manConnFactory;
     }

     public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) 
          throws ResourceException {

          System.out.println("ManagedConnectionImpl.getConnection(Subject, ConnectionRequestInfo) called");

          ConnectionImpl conn = new ConnectionImpl(this);

          return conn;
     }

     public void destroy() throws ResourceException {

          System.out.println("ManagedConnectionImpl.destroy() called");

          isDestroyed=true;

          cleanup();
     }

     public void cleanup() throws ResourceException {

          System.out.println("ManagedConnectionImpl.cleanup() called");
     }

    public void associateConnection(Object connection) throws ResourceException {

        throw new NotSupportedException("ManagedConnectionImpl.associateConnection() not supported.");
    }

    public void addConnectionEventListener(ConnectionEventListener connEventListener) {

	  System.out.println("ManagedConnectionImpl.addConnectionEventListener(ConnectionEventListener) called");

        this.connEventListener = connEventListener;
    }

    public void removeConnectionEventListener (ConnectionEventListener connEventListener) {

    }

    public XAResource getXAResource() throws ResourceException {

        throw new NotSupportedException("Global transactions are not supported");
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {

        throw new NotSupportedException("Local transactions are not supported");        
    }

     public ManagedConnectionMetaData getMetaData() throws ResourceException {
     
          if (isDestroyed)
               throw new ResourceException ("Managed connection has already been closed.");

          return new ManagedConnectionMetaDataImpl (this);
     }

     public void setLogWriter(PrintWriter manConnLogWriter) {

          this.manConnLogWriter = manConnLogWriter;
     }

     public PrintWriter getLogWriter() {

          return manConnLogWriter;
     }

     void sendEvent(int eventType, Exception e, Object connHandle) {

          System.out.println("ManagedConnectionImpl.sendEvent(int, e, connHandle) called");
	
          ConnectionEvent connEvent = null;

          if (e == null) 
               connEvent = new ConnectionEvent(this, eventType);
          else 
               connEvent = new ConnectionEvent(this, eventType, e);
          
          connEvent.setConnectionHandle(connHandle);

          switch (connEvent.getId()) {
               case ConnectionEvent.CONNECTION_CLOSED:
                    this.connEventListener.connectionClosed(connEvent);
                    break;
               case ConnectionEvent.LOCAL_TRANSACTION_STARTED:
                    this.connEventListener.localTransactionStarted(connEvent);
                    break;
               case ConnectionEvent.LOCAL_TRANSACTION_COMMITTED:
                    this.connEventListener.localTransactionCommitted(connEvent);
                    break;
               case ConnectionEvent.LOCAL_TRANSACTION_ROLLEDBACK:
                    this.connEventListener.localTransactionRolledback(connEvent);
                    break;
               case ConnectionEvent.CONNECTION_ERROR_OCCURRED:
                    this.connEventListener.connectionErrorOccurred(connEvent);
                    break;
               default:
                    throw new IllegalArgumentException("Unsupported event: " + connEvent.getId());
          }
     }

     ManagedConnectionFactory getManagedConnectionFactory() {

          return manConnFactory;
     }
}